package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntityUserMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityUserManager
import ru.yandex.crm.apphost.proto.entitystorage.EntityUserServiceBase
import ru.yandex.crm.apphost.proto.entitystorage.Entitystorage
import ru.yandex.web.apphost.api.request.RequestMeta
import java.util.UUID

class EntityUserService(
    private val entityUserManager: EntityUserManager,
    private val entityUserMapper: EntityUserMapper
) : EntityUserServiceBase() {
    override fun getUsers(
        requestMeta: RequestMeta,
        requestBody: Entitystorage.GetUsersRequest
    ): Entitystorage.EntityUserResponse {
        val entityUsers = entityUserManager.getEntityUsers(
            UUID.fromString(requestBody.getUsers.entityId),
        )

        return Entitystorage.EntityUserResponse.newBuilder()
            .addAllEntityUsers(entityUsers.map { entityUserMapper.toProtobufModel(it) })
            .build()
    }

    override fun addEntityUser(
        requestMeta: RequestMeta,
        requestBody: Entitystorage.EntityUserRequest
    ): Entitystorage.EntityUserResponse {
        val entityUser = entityUserMapper.fromProtobufModel(requestBody.entityUser)
        val entityUsers = entityUserManager.addEntityUser(entityUser)

        return Entitystorage.EntityUserResponse.newBuilder()
            .addAllEntityUsers(entityUsers.map { entityUserMapper.toProtobufModel(it) })
            .build()
    }

    override fun removeEntityUser(
        requestMeta: RequestMeta,
        requestBody: Entitystorage.EntityUserRequest
    ): Entitystorage.EntityUserResponse {
        val entityUser = entityUserMapper.fromProtobufModel(requestBody.entityUser)
        val entityUsers = entityUserManager.removeEntityUser(entityUser)

        return Entitystorage.EntityUserResponse.newBuilder()
            .addAllEntityUsers(entityUsers.map { entityUserMapper.toProtobufModel(it) })
            .build()
    }
}
