package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeFilterMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeSchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.ProtoAttributeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeSchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.AttributeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.Filter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl.EqualityFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl.NumberRangeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl.ValueListFilter
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage

class AttributeFilterMapperImpl(
    private val attributeSchemaMapper: AttributeSchemaMapper
) : AttributeFilterMapper {
    override fun fromProtobufModel(protoMessage: ProtoAttributeFilter): AttributeFilter {
        val attributeSchema = attributeSchemaMapper.fromProtobufModel(protoMessage.schema)
        val attributeFilter = mapFilter(protoMessage, attributeSchema)
        return AttributeFilter(
            schema = attributeSchema,
            filter = attributeFilter
        )
    }

    override fun toProtobufModel(model: AttributeFilter): ProtoAttributeFilter {
        error("This operation is not needed")
    }

    private fun mapFilter(protoMessage: ProtoAttributeFilter, schema: AttributeSchema): Filter =
        when (protoMessage.filterCase) {
            Entitystorage.AttributeFilter.FilterCase.EQUALITY -> EqualityFilter(
                schema.type.protoValueToValue(
                    protoMessage.equality.value
                )
            )
            Entitystorage.AttributeFilter.FilterCase.NUMBER_RANGE -> NumberRangeFilter(
                minValue = protoMessage.numberRange.minValue,
                includeMin = protoMessage.numberRange.includeMin,
                maxValue = protoMessage.numberRange.maxValue,
                includeMax = protoMessage.numberRange.includeMax
            )
            Entitystorage.AttributeFilter.FilterCase.FILTER_NOT_SET -> error("Attribute filter must be set")
            Entitystorage.AttributeFilter.FilterCase.LIST -> ValueListFilter(valueList =
            protoMessage.list.valuesList.map {
                schema.type.protoValueToValue(it)
            })
        }
}
