package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeSchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeTypeMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.ProtoAttributeSchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeSchema

class AttributeSchemaMapperImpl(
    private val attributeTypeMapper: AttributeTypeMapper
) : AttributeSchemaMapper {
    override fun fromProtobufModel(protoMessage: ProtoAttributeSchema): AttributeSchema = AttributeSchema(
        name = protoMessage.name,
        type = attributeTypeMapper.fromProtobufModel(protoMessage.type),
        fieldNumber = protoMessage.fieldNumber,
        isIndexed = protoMessage.isIndexed
    )

    override fun toProtobufModel(model: AttributeSchema): ProtoAttributeSchema = ProtoAttributeSchema.newBuilder()
        .setName(model.name)
        .setType(attributeTypeMapper.toProtobufModel(model.type))
        .setFieldNumber(model.fieldNumber)
        .setIsIndexed(model.isIndexed)
        .build()
}
