package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeTypeMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.ProtoAttributeType
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeType
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeTypeImpl

class AttributeTypeMapperImpl : AttributeTypeMapper {
    override fun fromProtobufModel(protoMessage: ProtoAttributeType): AttributeType =
        when (protoMessage) {
            ProtoAttributeType.STRING -> AttributeTypeImpl.STRING
            ProtoAttributeType.INT -> AttributeTypeImpl.INT
            ProtoAttributeType.TIMESTAMP -> AttributeTypeImpl.TIMESTAMP
            ProtoAttributeType.BOOL -> AttributeTypeImpl.BOOL
            ProtoAttributeType.UUID -> AttributeTypeImpl.UUID
            ProtoAttributeType.FLOAT -> AttributeTypeImpl.FLOAT
            ProtoAttributeType.DOUBLE -> AttributeTypeImpl.DOUBLE
            ProtoAttributeType.UNRECOGNIZED -> error("Unrecognized attribute type")
        }

    override fun toProtobufModel(model: AttributeType): ProtoAttributeType =
        when (model) {
            AttributeTypeImpl.INT -> ProtoAttributeType.INT
            AttributeTypeImpl.STRING -> ProtoAttributeType.STRING
            AttributeTypeImpl.TIMESTAMP -> ProtoAttributeType.TIMESTAMP
            AttributeTypeImpl.BOOL -> ProtoAttributeType.BOOL
            AttributeTypeImpl.UUID -> ProtoAttributeType.UUID
            AttributeTypeImpl.FLOAT -> ProtoAttributeType.FLOAT
            AttributeTypeImpl.DOUBLE -> ProtoAttributeType.DOUBLE
        }
}
