package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeSchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntitySchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.ProtoEntitySchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import java.util.UUID

class EntitySchemaMapperImpl(
    private val attributeSchemaMapper: AttributeSchemaMapper
) : EntitySchemaMapper {
    override fun fromProtobufModel(protoMessage: ProtoEntitySchema): EntitySchema = EntitySchema(
        organizationId =  protoMessage.organizationId,
        metaId = UUID.fromString(protoMessage.metaId),
        attributes = protoMessage.attributesList.map { attributeSchemaMapper.fromProtobufModel(it) }
    )

    override fun toProtobufModel(model: EntitySchema): ProtoEntitySchema = ProtoEntitySchema.newBuilder()
        .setOrganizationId(model.organizationId)
        .setMetaId(model.metaId.toString())
        .addAllAttributes(model.attributes.map { attributeSchemaMapper.toProtobufModel(it) })
        .build()
}
