package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntityUserMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.ProtoEntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUserRoleEnum
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage

class EntityUserMapperImpl : EntityUserMapper {
    override fun fromProtobufModel(protoMessage: ProtoEntityUser): EntityUser =
        EntityUser(
            userId = protoMessage.userId,
            role = mapRoleFromProtobuf(protoMessage.role)
        )

    override fun toProtobufModel(model: EntityUser): ProtoEntityUser =
        ProtoEntityUser.newBuilder()
            .setUserId(model.userId!!)
            .setRole(Entitystorage.EntityUser.Role.forNumber(model.role!!.value.toInt()))
            .build()


    private fun mapRoleFromProtobuf(protoRole: Entitystorage.EntityUser.Role): EntityUserRoleEnum =
        when(protoRole){
            Entitystorage.EntityUser.Role.AUTHOR -> EntityUserRoleEnum.AUTHOR
            Entitystorage.EntityUser.Role.RESPONSIBLE -> EntityUserRoleEnum.RESPONSIBLE
            Entitystorage.EntityUser.Role.OBSERVER -> EntityUserRoleEnum.OBSERVER
            Entitystorage.EntityUser.Role.UNRECOGNIZED -> error("Unexpected role in proto message")
        }
}

