package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.AttributeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.Entity
import java.util.UUID

interface EntityRepository {
    fun findOne(id: UUID): Entity?
    fun findOne(internalId: Long): Entity?
    fun findAll(organizationId: Long): List<Entity>
    fun create(entity: Entity): Entity
    fun update(entityId: UUID, version: Int, updatedValues: Map<Int, Any?>): Entity
    fun delete(id: UUID)
    fun filter(organizationId: Long, attributeFilter: AttributeFilter): List<Entity>
    fun filterByInternalIdRange(internalIdMin: Double?, includeMin: Boolean?, internalIdMax: Double?, includeMax: Boolean?): List<Entity>
    fun filterByIdList(ids: List<UUID>): List<Entity>
    fun filterByInternalIdsList(internalIds: List<Long>): List<Entity>
}
