package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository

import org.hibernate.engine.spi.SessionFactoryImplementor
import org.hibernate.mapping.Column
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.library.kotlin.database.Repository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSessionManager
import java.util.UUID

fun HibernateSessionManager.getType(
    type: Int,
    length: Int = Column.DEFAULT_LENGTH,
    precision: Int = Column.DEFAULT_PRECISION,
    scale: Int = Column.DEFAULT_SCALE
): String {
    val dialect = (sessionFactory as SessionFactoryImplementor).jdbcServices.dialect
    return dialect.getTypeName(type, length.toLong(), precision, scale)
}
