package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository

import org.hibernate.Session
import org.koin.core.parameter.parametersOf
import org.koin.mp.KoinPlatformTools
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema

fun Session.getEntityRepository(entitySchema: EntitySchema): EntityRepository {
    val koin = KoinPlatformTools.defaultContext().get()
    return koin.get(EntityRepository::class) { parametersOf(this, entitySchema) }
}

fun Session.getSchemalessEntityRepository(): SchemalessEntityRepository {
    val koin = KoinPlatformTools.defaultContext().get()
    return koin.get(SchemalessEntityRepository::class) { parametersOf(this) }
}
