package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.EntityUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUserRoleEnum
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.UUID

class EntityUserRepositoryImpl (session: Session) :
    HibernateRepository<EntityUser, Long>(session, EntityUser::class.java),
    EntityUserRepository {
    override fun getEntityUsers(entityId: UUID, role: EntityUserRoleEnum?): List<EntityUser> =
        if (role == null) {
            findAll("from EntityUser where entityId = :entityId",
                "entityId" to entityId)
        } else {
            findAll("from EntityUser where entityId = :entityId and role = :role",
                "entityId" to entityId,
                "role" to role)
        }

    override fun findOne(entityId: UUID, userId: Long, role: EntityUserRoleEnum): EntityUser? =
        findOne("from EntityUser where entityId = :entityId and userId = :userId and role = :role",
            "entityId" to entityId,
            "userId" to userId,
            "role" to role)
}
