package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.SchemalessEntityRepository
import java.math.BigInteger
import java.util.UUID

class SchemalessEntityRepositoryImpl(
    private val session: Session,
)  : SchemalessEntityRepository {
    override fun exists(id: UUID): Boolean {
        val entityCount = session.createNativeQuery("select count(*) from entitystorage.entity where id = :id")
            .setParameter("id", id)
            .resultList[0] as BigInteger

        return entityCount.toLong() > 0
    }
}
