package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model

import java.time.Instant
import java.util.UUID
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.IdClass
import javax.persistence.Table
import javax.persistence.Index as JPAIndex

@Entity
@Table(
    name = "index", schema = "entitystorage", indexes = [
        JPAIndex(columnList = "meta_id, entity_id, field_number, string_value"),
        JPAIndex(columnList = "meta_id, entity_id, field_number, int_value"),
        JPAIndex(columnList = "meta_id, entity_id, field_number, timestamp_value"),
        JPAIndex(columnList = "meta_id, entity_id, field_number, bool_value"),
        JPAIndex(columnList = "meta_id, entity_id, field_number, uuid_value")
    ]
)
@IdClass(IndexId::class)
open class Index(
    @Id
    @Column(name = "organization_id", nullable = false)
    open var organizationId: Long? = null,

    @Id
    @Column(name = "meta_id", nullable = false)
    open var metaId: UUID? = null,

    @Id
    @Column(name = "entity_id", nullable = false)
    open var entityId: UUID? = null,

    @Id
    @Column(name = "field_number", nullable = false)
    open var fieldNumber: Int? = null,

    @Column(name = "string_value")
    open var stringValue: String? = null,

    @Column(name = "int_value")
    open var intValue: Int? = null,

    @Column(name = "timestamp_value")
    open var timestampValue: Instant? = null,

    @Column(name = "bool_value")
    open var boolValue: Boolean? = null,

    @Column(name = "uuid_value")
    open var uuidValue: UUID? = null,

    @Column(name = "float_value")
    open var floatValue: Float? = null,

    @Column(name = "double_value")
    open var doubleValue: Double? = null,
)
