package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeType
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.Filter

class EqualityFilter (
    val value: Any
) : Filter {
    override fun getQueryString(type: AttributeType): String =
        "and idx.${type.queryIndexField}=:value"

    override fun getParameterList(type: AttributeType): Map<String, Any?> =
        mapOf("value" to type.valueToDbValue(value))
}
