package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeType
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeTypeImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.Filter

class NumberRangeFilter(
    val minValue: Double? = null,
    val includeMin: Boolean = false,
    val maxValue: Double? = null,
    val includeMax: Boolean = false
) : Filter {
    override fun getQueryString(type: AttributeType): String {
        var filterString = ""
        if (minValue != null) {
            filterString += "and idx.${type.queryIndexField} ${if (includeMin) ">=" else ">"} :minValue "
        }

        if (maxValue != null) {
            filterString += "and idx.${type.queryIndexField} ${if (includeMax) "<=" else "<"} :maxValue "
        }
        return filterString
    }

    override fun getParameterList(type: AttributeType): Map<String, Any?> {
        val parameters = mutableMapOf<String, Any?>()
        if (minValue != null) {
            parameters.put("minValue", type.valueToDbValue(getTypedNumberValue(minValue, type)))
        }

        if (maxValue != null) {
            parameters.put("maxValue", type.valueToDbValue(getTypedNumberValue(maxValue, type)))
        }
        return parameters
    }

    fun getTypedNumberValue(value: Double?, type: AttributeType) = when (type) {
        AttributeTypeImpl.DOUBLE -> value
        AttributeTypeImpl.FLOAT -> value?.toFloat()
        AttributeTypeImpl.INT -> value?.toInt()
        else -> error("Not suitable filter for attribute")
    }
}
