package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeType
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.Filter

class ValueListFilter(
    val valueList: List<Any>
)  : Filter {
    override fun getQueryString(type: AttributeType): String =
        "and idx.${type.queryIndexField} IN (${valueList.indices.joinToString(","){ ":value$it" } })"

    override fun getParameterList(type: AttributeType): Map<String, Any?> =
        valueList.mapIndexed { index, anyValue -> ("value$index" to type.valueToDbValue(anyValue)) }.toMap()
}
