package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.AttributeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.Entity
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import java.util.UUID

interface EntityManagementService {
    fun createEntity(organizationId: Long, entitySchema: EntitySchema, entity: Entity, users: List<EntityUser>): Entity
    fun updateEntity(organizationId: Long, entitySchema: EntitySchema, entityId: UUID, version: Int, attributes: Map<Int, Any?>): Entity
    fun deleteEntity(organizationId: Long, entitySchema: EntitySchema, entityId: UUID)
    fun listEntities(organizationId: Long, entitySchema: EntitySchema, filters: List<AttributeFilter>): List<Entity>
}
