package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.EntityUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.getSchemalessEntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUserRoleEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityUserManager
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.util.UUID

class EntityUserManagerImpl : EntityUserManager {
    override fun getEntityUsers(entityId: UUID): List<EntityUser> =
        transaction {
            val entityRepository = getSchemalessEntityRepository()
            if (!entityRepository.exists(entityId))
                error("Unable to find entity with id $entityId")

            val entityUserRepository = getRepository<EntityUserRepository>()

            entityUserRepository.getEntityUsers(entityId)
        }

    override fun addEntityUser(entityUser: EntityUser): List<EntityUser> =
        transaction {
            val entityId = entityUser.entityId!!
            val entityRepository = getSchemalessEntityRepository()
            if (!entityRepository.exists(entityId))
                error("Unable to find entity with id $entityId")

            val entityUserRepository = getRepository<EntityUserRepository>()
            val currentEntityUser = entityUserRepository.findOne(entityId, entityUser.userId!!, entityUser.role!!)

            if (currentEntityUser != null)
                error("Entity user in role is already existed")

            entityUserRepository.save(entityUser)
            entityUserRepository.getEntityUsers(entityId)
        }

    override fun removeEntityUser(entityUser: EntityUser): List<EntityUser> =
        transaction {
            val entityId = entityUser.entityId!!
            val entityRepository = getSchemalessEntityRepository()
            if (!entityRepository.exists(entityId))
                error("Unable to find entity with id $entityId")

            val entityUserRepository = getRepository<EntityUserRepository>()

            val currentEntityUser: EntityUser
            if (entityUser.role == EntityUserRoleEnum.AUTHOR) {
                val authors = entityUserRepository.getEntityUsers(entityId, entityUser.role)
                currentEntityUser = authors.firstOrNull { it.userId == entityUser.userId }
                    ?: error("No entity user in role to remove")

                if (authors.size == 1){
                    error("Can't remove single author")
                }
            } else {
                currentEntityUser = entityUserRepository.findOne(entityId, entityUser.userId!!, entityUser.role!!)
                    ?: error("No entity user in role to remove")
            }

            entityUserRepository.delete(currentEntityUser)
            entityUserRepository.getEntityUsers(entityId)
        }
}
