package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut

import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeSchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeTypeImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import java.util.UUID

abstract class EntityTests : KoinTest {
    protected var metaId = UUID.randomUUID()
    protected var versionId = UUID.randomUUID()

    protected fun createEntitySchema(selectedFields: Set<Int>? = null
    ): EntitySchema = EntitySchema(
        organizationId = 1,
        metaId = metaId,
        attributes = listOf(
            AttributeSchema(
                name = "Author",
                type = AttributeTypeImpl.STRING,
                fieldNumber = 0,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Severity",
                type = AttributeTypeImpl.INT,
                fieldNumber = 1,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Created_at",
                type = AttributeTypeImpl.TIMESTAMP,
                fieldNumber = 2,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Active",
                type = AttributeTypeImpl.BOOL,
                fieldNumber = 3,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Uuid",
                type = AttributeTypeImpl.UUID,
                fieldNumber = 4,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Float",
                type = AttributeTypeImpl.FLOAT,
                fieldNumber = 5,
                isIndexed = true
            ),
            AttributeSchema(
                name = "Double",
                type = AttributeTypeImpl.DOUBLE,
                fieldNumber = 6,
                isIndexed = true
            ),
        ).filter { selectedFields == null || it.fieldNumber in selectedFields }
    )
}
