package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.repository

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.getEntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.Entity
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.EntityDbBackedTests
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.time.Instant
import java.time.temporal.ChronoUnit
import java.util.UUID
import kotlin.test.assertEquals
import kotlin.test.assertNotNull
import kotlin.test.assertNull

open class EntityRepositoryTests : EntityDbBackedTests() {

    lateinit var entitySchema: EntitySchema

    @BeforeEach
    fun beforeEach() {
        entitySchema = createEntitySchema()
    }

    @Test
    fun `create, save and get one issue`() {
        // Arrange

        // Act
        val dt = Instant.now().truncatedTo(ChronoUnit.MILLIS)
        val uuid = UUID.fromString("973545e4-f09d-11ec-8ea0-0242ac120002")
        val departmentId = UUID.fromString("779b8307-b6d8-4aff-8fd0-7e3dc260e570")
        val id = transaction {
            var entity = Entity(
                organizationId = 1,
                departmentId = departmentId,
                metaId = entitySchema.metaId,
                version = 1,
                attributeValues = mutableMapOf(
                    0 to "New value",
                    1 to 50,
                    2 to dt,
                    3 to true,
                    4 to uuid
                )
            )
            val repository = getEntityRepository(entitySchema)
            entity = repository.create(entity)
            entity.id
        }
        // Assert

        transaction {
            val repository = getEntityRepository(entitySchema)
            val entityObject = repository.findOne(id!!)
            assertNotNull(entityObject)
            assertEquals(1, entityObject.internalId)
            assertEquals(departmentId, entityObject.departmentId)
            assertEquals("New value", entityObject.attributeValues[0])
            assertEquals(50, entityObject.attributeValues[1])
            assertEquals(dt, entityObject.attributeValues[2])
            assertEquals(true, entityObject.attributeValues[3])
            assertEquals(uuid, entityObject.attributeValues[4])
        }
    }

    @Test
    fun `if unknown id get null entity`() {
        //Arrange
        //Act
        val entityObject = transaction {
            val repository = getEntityRepository(entitySchema)
            repository.findOne(UUID.randomUUID())
        }

        //Assert
        assertNull(entityObject)
    }
}
