package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.service

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.get
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.getEntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.AttributeFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeSchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.AttributeTypeImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.Entity
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUserRoleEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.filters.impl.EqualityFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityManagementService
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.EntityDbBackedTests
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.time.Instant
import java.time.temporal.ChronoUnit
import java.util.UUID
import kotlin.test.assertEquals
import kotlin.test.assertFalse
import kotlin.test.assertNotNull

class AttributeSelectionTests : EntityDbBackedTests() {

    lateinit var entitySchema: EntitySchema

    @BeforeEach
    fun beforeEach() {
        entitySchema = createEntitySchema()
    }

    @Test
    fun `list entities with filter and selector`() {
        // Arrange
        val entityManagementService = get<EntityManagementService>()
        (1..5).forEach {
            val dt = Instant.now().truncatedTo(ChronoUnit.MILLIS)
            val entity = createEntity(entitySchema,dt,"Author$it", it, false, UUID.randomUUID(), it.toFloat(), it.toDouble())
            val users = listOf(EntityUser(userId = 1, role = EntityUserRoleEnum.AUTHOR))
            get<EntityManagementService>().createEntity(1, entitySchema, entity, users)
        }
        // Act
        val filters = listOf(
            AttributeFilter(
                schema = AttributeSchema(
                    type = AttributeTypeImpl.STRING,
                    fieldNumber = 0,
                    name = "Author",
                    isIndexed = true
                ),
                filter = EqualityFilter(value = "Author2")
            )
        )
        val selectionSchema = createEntitySchema(setOf(1, 3, 4))
        val entities = entityManagementService.listEntities(1, selectionSchema, filters)

        // Assert
        assertEquals(1, entities.size)
        assertEquals(2, entities[0].attributeValues[1])
        assertFalse(entities[0].attributeValues.containsKey(0))
        assertFalse(entities[0].attributeValues.containsKey(2))
    }
}
