package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.service

import org.junit.jupiter.api.BeforeEach
import org.koin.test.get
import org.junit.jupiter.api.Test
import org.junit.jupiter.api.assertThrows
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.getEntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntitySchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUser
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.model.EntityUserRoleEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityManagementService
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.ut.EntityDbBackedTests
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.time.Instant
import java.time.temporal.ChronoUnit
import java.util.UUID
import kotlin.test.assertEquals
import kotlin.test.assertNotNull

class OptimisticLockingTests : EntityDbBackedTests() {

    lateinit var entitySchema: EntitySchema

    @BeforeEach
    fun beforeEach() {
        entitySchema = createEntitySchema()
    }

    @Test
    fun `create entity and check version is 1`(){
        // Arrange
        val instant = Instant.now().truncatedTo(ChronoUnit.MILLIS)
        val uuid = UUID.fromString("973545e4-f09d-11ec-8ea0-0242ac120002")
        val entity = createEntity(entitySchema,instant,"John Doe", 99, false, uuid,3.1415f, 2.7182818284590)
        val users = listOf(EntityUser(userId = 1, role = EntityUserRoleEnum.AUTHOR))

        // Act
        val outEntity = get<EntityManagementService>().createEntity(1, entitySchema, entity, users)

        // Assert
        assertEquals(1, outEntity.version)

        transaction {
            val repository = getEntityRepository(entitySchema)
            val entity = repository.findOne(outEntity.id!!)
            assertNotNull(entity)
            assertEquals(1, entity.version)
        }
    }

    @Test
    fun `update created entity and check version is 2`(){
        // Arrange
        val dt = Instant.now().truncatedTo(ChronoUnit.MILLIS)
        val id = transaction {
            val repository = getEntityRepository(entitySchema)
            var entityObject = createEntity(entitySchema, dt)
            entityObject = repository.create(entityObject)
            entityObject.id
        }
        // Act
        val updatedAttributes = mapOf(0 to "Tolstoy")

        val entityManagementService = get<EntityManagementService>()
        val outEntity = entityManagementService.updateEntity(1, entitySchema, id!!, 1, updatedAttributes)

        // Assert
        transaction {
            val dbEntity = getEntityRepository(entitySchema).findOne(id)
            assertEquals(2, outEntity.version)
            assertEquals("Tolstoy", outEntity.attributeValues[0])

            assertEquals("Tolstoy", dbEntity!!.attributeValues[0])
            assertEquals(2, dbEntity.version)
        }
    }

    @Test
    fun `update entity with outdatd version fails`(){
        // Arrange
        val dt = Instant.now().truncatedTo(ChronoUnit.MILLIS)
        val id = transaction {
            val repository = getEntityRepository(entitySchema)
            var entityObject = createEntity(entitySchema, dt)
            entityObject = repository.create(entityObject)
            entityObject.id
        }
        // Act
        val updatedAttributes = mapOf(0 to "Tolstoy")

        val entityManagementService = get<EntityManagementService>()
        entityManagementService.updateEntity(1, entitySchema, id!!, 1, updatedAttributes)

        val updatedAttributes2 = mapOf(0 to "Dostoevsky")
        assertThrows<Exception> { entityManagementService.updateEntity(1, entitySchema, id, 1, updatedAttributes2) }

        // Assert
        transaction {
            val dbEntity = getEntityRepository(entitySchema).findOne(id)
            assertEquals("Tolstoy", dbEntity!!.attributeValues[0])
            assertEquals(2, dbEntity.version)
        }
    }
}
