package ru.yandex.crm.apphost.kotlin.handlers.example

import NAppHostHttp.Http.THttpResponse
import com.google.protobuf.ByteString
import org.jooq.impl.DSL
import ru.yandex.crm.apphost.proto.example.Example.EchoRequest
import ru.yandex.crm.apphost.proto.example.Example.EchoResponse
import ru.yandex.crm.apphost.proto.example.ExampleServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class ExampleService : ExampleServiceBase() {
    override fun echo(requestMeta: RequestMeta, requestBody: EchoRequest): EchoResponse {
        val response = THttpResponse.newBuilder()
            .setContent(ByteString.copyFromUtf8("request content: ").concat(requestBody.request.content))
            .setStatusCode(200)
            .build()

        return EchoResponse.newBuilder()
            .setResponse(response)
            .build()
    }
}
