package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager

import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.http.parser.HttpParserHandlerBase
import ru.yandex.crm.apphost.proto.organizationmanager.Organizationmanager.*
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationData
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.UpdateOrganizationData
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.*
import ru.yandex.passport.tvmauth.TvmClient

class HttpParserHandler(tvmClient: TvmClient) : HttpParserHandlerBase(tvmClient) {

    override val path = "/init/organization"

    init {
        get("organizations/list") {
            val command = GetOrganizationListCommand.newBuilder().build()
            context.addProtobufItem(GetOrganizationListCommand.getDescriptor().getAppHostType(), command)
        }

        get("organization/{organizationId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val command = OrganizationId.newBuilder()
                .setValue(organizationId)
                .build()
            context.addProtobufItem(OrganizationId.getDescriptor().getAppHostType(), command)
        }

        put("organization/create") {
            val body = request.content
            val organizationModel = OrganizationData.parseFrom(body)
            val command = CreateOrganizationCommand.newBuilder()
                .setTargetOrganization(organizationModel)
                .build()
            context.addProtobufItem(CreateOrganizationCommand.getDescriptor().getAppHostType(), command)
        }

        patch("organization/update/{organizationId}") {
            val body = request.content
            val organizationModel = UpdateOrganizationData.parseFrom(body)
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val command = UpdateOrganizationCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setTargetOrganization(organizationModel)
                .build()
            context.addProtobufItem(UpdateOrganizationCommand.getDescriptor().getAppHostType(), command)
        }

        post("organization/archive/{organizationId}") {
            val organizationId = pathParameters["organizationId"]
            val command = ArchiveOrganizationCommand.newBuilder()
                .setOrganizationId(organizationId)
                .build()
            context.addProtobufItem(ArchiveOrganizationCommand.getDescriptor().getAppHostType(), command)
        }
    }
}
