package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager

import NAppHostHttp.Http.THttpResponse
import com.google.protobuf.Message
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.extensions.getSingleRequestItemOrNull
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationResponse
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationsResponse
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {

    override val path = "/response/organization"

    override fun handle(ctx: RequestContext) {
        val singleOrganizationResponse =
            ctx.getSingleRequestItemOrNull(OrganizationResponse.getDescriptor().getAppHostType())
                ?.getProtobufData(OrganizationResponse.getDefaultInstance())
        if (singleOrganizationResponse != null) {
            val response = buildHttpResponse(singleOrganizationResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val organizationsResponse =
            ctx.getSingleRequestItemOrNull(OrganizationsResponse.getDescriptor().getAppHostType())
                ?.getProtobufData(OrganizationsResponse.getDefaultInstance())
        if (organizationsResponse != null) {
            val response = buildHttpResponse(organizationsResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }
    }

    private fun buildHttpResponse(response: Message): THttpResponse {
        return THttpResponse.newBuilder()
            .setContent(response.toByteString())
            .build()
    }
}
