package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.api.*
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.OrganizationRepository
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.OrganizationUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.impl.OrganizationRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.UserRepository
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.impl.OrganizationServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.OrganizationEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.impl.OrganizationEntityMapperImpl
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder

fun HostBuilder.withOrganizationModule() = withModule(module {
    single { OrganizationManagerSchema() } bind HibernateSchema::class
    single { UserManagerSchema() } bind HibernateSchema::class

    factory { params -> OrganizationRepositoryImpl(params.get()) } bind OrganizationRepository::class
    factory { params -> UserRepository(params.get()) } bind UserRepository::class
    factory { params -> OrganizationUserRepository(params.get()) } bind OrganizationUserRepository::class

    single { OrganizationEntityMapperImpl() } bind OrganizationEntityMapper::class

    single { OrganizationServiceImpl(get()) } bind OrganizationService::class

    single { ArchiveOrganizationHandler() } bind AppHostPathHandler::class
    single { CreateOrganizationHandler(get()) } bind AppHostPathHandler::class
    single { GetOrganizationHandler(get()) } bind AppHostPathHandler::class
    single { GetOrganizationsListHandler(get()) } bind AppHostPathHandler::class
    single { UpdateOrganizationHandler(get()) } bind AppHostPathHandler::class

    single { HttpParserHandler(get()) } bind AppHostPathHandler::class
    single { HttpPresenterHandler() } bind AppHostPathHandler::class
})
