package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.apphost.proto.organizationmanager.Organizationmanager.CreateOrganizationCommand
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationResponse
import ru.yandex.web.apphost.api.request.RequestContext

class CreateOrganizationHandler(
    private val service: OrganizationService
) : AppHostPathHandler {

    override val path = "/organization/create"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(CreateOrganizationCommand.getDescriptor().getAppHostType())
            .getProtobufData(CreateOrganizationCommand.getDefaultInstance())

        val organization = command.targetOrganization
        val createdOrganization = service.createOrganization(organization)

        val response = OrganizationResponse.newBuilder()
            .setOrganization(createdOrganization)
            .build()

        ctx.addProtobufItem(OrganizationResponse.getDescriptor().getAppHostType(), response)
    }
}
