package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.Organization
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationId
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationHandler(
    private val service: OrganizationService
) : AppHostPathHandler {

    override val path = "/organization/get"

    override fun handle(ctx: RequestContext) {
        val organizationId = ctx.getSingleRequestItem(OrganizationId.getDescriptor().getAppHostType())
            .getProtobufData(OrganizationId.getDefaultInstance())

        val organization = service.getOrganization(organizationId.value)

        val response = OrganizationResponse.newBuilder()
            .setOrganization(organization)
            .build()
        ctx.addProtobufItem(OrganizationResponse.getDescriptor().getAppHostType(), response)
        ctx.addProtobufItem(Organization.getDescriptor().getAppHostType(), organization) // TODO: replace with flag
    }
}
