package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.apphost.proto.organizationmanager.Organizationmanager.GetOrganizationListCommand
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationsResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationsListHandler(
    private val service: OrganizationService
) : AppHostPathHandler {

    override val path = "/organization/all/get"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetOrganizationListCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetOrganizationListCommand.getDefaultInstance())

        val organizations = service.getAllOrganizations()

        val response = OrganizationsResponse.newBuilder()
            .addAllOrganizations(organizations)
            .build()
        ctx.addProtobufItem(OrganizationsResponse.getDescriptor().getAppHostType(), response)
    }
}
