package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.apphost.proto.organizationmanager.Organizationmanager.UpdateOrganizationCommand
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationResponse
import ru.yandex.web.apphost.api.request.RequestContext

class UpdateOrganizationHandler(
    private val service: OrganizationService
) : AppHostPathHandler {

    override val path = "/organization/update"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(UpdateOrganizationCommand.getDescriptor().getAppHostType())
            .getProtobufData(UpdateOrganizationCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val newOrganization = command.targetOrganization
        val updatedOrganization = service.updateOrganization(organizationId, newOrganization)

        val response = OrganizationResponse.newBuilder()
            .setOrganization(updatedOrganization)
            .build()
        ctx.addProtobufItem(OrganizationResponse.getDescriptor().getAppHostType(), response)
    }
}
