package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.OrganizationRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository

open class OrganizationRepositoryImpl(
    session: Session
) : HibernateRepository<Organization, Long>(session, Organization::class.java), OrganizationRepository {

    override fun organizationContainsUser(organizationId: Long, userId: Long): Boolean {
        val queryString = "SELECT EXISTS (SELECT organizationmanager.organization.id FROM organizationmanager.organization " +
            "JOIN usermanager.organization_user ON usermanager.organization_user.organization_id = " +
            "organizationmanager.organization.id AND usermanager.organization_user.user_id = :userId AND " +
            "organizationmanager.organization.id = :organizationId)"
        val query = session.createNativeQuery(queryString).apply {
            setParameter("userId", userId)
            setParameter("organizationId", organizationId)
        }
        return query.singleResult as Boolean
    }
}

