package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.impl

import org.hibernate.Hibernate
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.impl.OrganizationRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.OrganizationService
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.OrganizationEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.ProtoOrganization
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationData
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.UpdateOrganizationData

class OrganizationServiceImpl(
    private val organizationMapper: OrganizationEntityMapper,
) : OrganizationService {

    override fun getAllOrganizations(): List<ProtoOrganization> {
        val organizations = transaction {
            val repository = getRepository<OrganizationRepositoryImpl>()
            repository.findAll()
        }
        return organizations.map { organization ->
            organizationMapper.toProtobufModel(organization)
        }
    }

    override fun getOrganization(organizationId: Long): ProtoOrganization {
        return getOrganizationOrNull(organizationId)
            ?: error("Organization with id: $organizationId not found")
    }

    override fun getOrganizationOrNull(organizationId: Long): ProtoOrganization? {
        val organization = transaction {
            val repository = getRepository<OrganizationRepositoryImpl>()
            repository.findOne(organizationId)
        }
        return if (organization != null) {
            organizationMapper.toProtobufModel(organization)
        } else {
            null
        }
    }

    override fun createOrganization(model: OrganizationData): Organizationmanager.Organization {
        val entity = Organization(
            pool = model.pool,
            slug = model.slug,
            name = model.name,
        )
        val savedEntity = transaction {
            val repository = getRepository<OrganizationRepositoryImpl>()
            repository.save(entity)
        }
        return organizationMapper.toProtobufModel(savedEntity)
    }

    override fun updateOrganization(
        organizationId: Long,
        model: UpdateOrganizationData
    ): Organizationmanager.Organization {
        val savedOrganization = transaction {
            val repository = getRepository<OrganizationRepositoryImpl>()
            val targetOrganization = repository.findOne(organizationId)
                ?: error("Organization with id: $organizationId not found")

            if (model.hasNewName()) {
                targetOrganization.name = model.newName
            }
            if (model.hasNewPool()) {
                targetOrganization.pool = model.newPool
            }
            if (model.hasNewSlug()) {
                targetOrganization.slug = model.newSlug
            }

            repository.save(targetOrganization)
        }

        return organizationMapper.toProtobufModel(savedOrganization)
    }
}
