package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.OrganizationEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.ProtoOrganization
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationData
import ru.yandex.crm.proto.gallifrey.organizationmanager.Organizationmanager.OrganizationId

class OrganizationEntityMapperImpl : OrganizationEntityMapper {

    override fun toProtobufModel(organization: Organization): ProtoOrganization {
        val data = OrganizationData.newBuilder()
            .setName(organization.name)
            .setSlug(organization.slug)
            .setPool(organization.pool)
            .build()
        return ProtoOrganization.newBuilder()
            .setId(OrganizationId.newBuilder().setValue(organization.id!!))
            .setData(data)
            .build()
    }
}
