package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.ut.repository

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.dal.usermanager.OrganizationUser
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.repository.impl.OrganizationRepositoryImpl
import kotlin.random.Random

class MockOrganizationRepository(session: Session) : OrganizationRepositoryImpl(session) {

    private val users = listOf(
        User(id = 1), User(id = 2), User(id = 3)
    )

    private val organizations = mutableListOf(
        Organization(1, 1, "slug1", "name1"),
        Organization(2, 1, "slug2", "name2"),
        Organization(3, 2, "slug3", "name3"),
        Organization(4, 2, "slug4", "name4"),
        Organization(5, 3, "slug5", "name5"),
    )

    init {
        // organizations[0].users = mutableListOf(organizationUsers[0])
        // organizations[1].users = mutableListOf(organizationUsers[1])
        // organizations[2].users = mutableListOf(organizationUsers[2])
        // organizations[3].users = mutableListOf(organizationUsers[3])
        // organizations[4].users = mutableListOf(organizationUsers[4])
    }

    override fun delete(id: Long) {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<Organization> {
        return organizations
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<Organization> {
        TODO("Not yet implemented")
    }

    override fun findOne(id: Long): Organization? {
        return organizations.find { it.id == id }
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): Organization? {
        TODO("Not yet implemented")
    }

    override fun save(entity: Organization): Organization {
        if (entity.id != null) {
            organizations.removeIf { it.id == entity.id }
            organizations.add(entity)
            return entity
        }
        entity.id = Random.nextLong()
        organizations.add(entity)
        return entity
    }

    override fun organizationContainsUser(organizationId: Long, userId: Long): Boolean {
        TODO("Not yet implemented")
    }
}
