package ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.ut.service.mappers

import org.junit.jupiter.api.Test
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.OrganizationEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.service.mappers.impl.OrganizationEntityMapperImpl
import kotlin.test.assertEquals

class OrganizationEntityMapperTests {

    @Test
    fun `map organization entity to protobuf model`() {
        val mapper: OrganizationEntityMapper = OrganizationEntityMapperImpl()

        // Create organizations
        val organization1 = Organization(
            id = 1,
            pool = 1,
            slug = "slug1",
            name = "name1"
        )
        val organization2 = Organization(
            id = 2,
            pool = 2,
            slug = "slug2",
            name = "name2",
        )
        val organization3 = Organization(
            id = 3,
            pool = 2,
            slug = "slug3",
            name = "name3"
        )

        // Mapping to protobuf models
        val proto1 = mapper.toProtobufModel(organization1)
        val proto2 = mapper.toProtobufModel(organization2)
        val proto3 = mapper.toProtobufModel(organization3)

        // Assertions
        assertEquals(organization1.id, proto1.id.value)
        assertEquals(organization1.pool, proto1.data.pool)
        assertEquals(organization1.slug, proto1.data.slug)
        assertEquals(organization1.name, proto1.data.name)

        assertEquals(organization2.id, proto2.id.value)
        assertEquals(organization2.pool, proto2.data.pool)
        assertEquals(organization2.slug, proto2.data.slug)
        assertEquals(organization2.name, proto2.data.name)

        assertEquals(organization3.id, proto3.id.value)
        assertEquals(organization3.pool, proto3.data.pool)
        assertEquals(organization3.slug, proto3.data.slug)
        assertEquals(organization3.name, proto3.data.name)
    }
}
