package ru.yandex.crm.apphost.kotlin.handlers.teammanager

import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.http.parser.HttpParserHandlerBase
import ru.yandex.crm.apphost.proto.teammanager.Teammanager.CreateTeamCommand
import ru.yandex.crm.apphost.proto.teammanager.Teammanager.DeleteTeamCommand
import ru.yandex.crm.apphost.proto.teammanager.Teammanager.GetTeamByIdCommand
import ru.yandex.crm.apphost.proto.teammanager.Teammanager.GetTeamListCommand
import ru.yandex.crm.apphost.proto.teammanager.Teammanager.UpdateTeamCommand
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamData
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.UpdateTeamData
import ru.yandex.passport.tvmauth.TvmClient

class HttpParserHandler(tvmClient: TvmClient) : HttpParserHandlerBase(tvmClient) {
    override val path: String = "/init/team"

    init {
        get("/organization/{organizationId}/teams") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val command = GetTeamListCommand.newBuilder()
                .setOrganizationId(organizationId)
                .build()
            context.addProtobufItem(GetTeamListCommand.getDescriptor().getAppHostType(), command)
        }

        get("/organization/{organizationId}/teams/{teamId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val teamId = pathParameters["teamId"]
            val command = GetTeamByIdCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setTeamId(teamId)
                .build()
            context.addProtobufItem(GetTeamByIdCommand.getDescriptor().getAppHostType(), command)
        }

        post("/organization/{organizationId}/teams") {
            val body = request.content
            val data = TeamData.parseFrom(body)
            val command = CreateTeamCommand.newBuilder()
                .setTeam(data)
                .build()
            context.addProtobufItem(CreateTeamCommand.getDescriptor().getAppHostType(), command)
        }

        put("/organization/{organizationId}/teams/{teamId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val teamId = pathParameters["teamId"]
            val body = request.content
            val data = UpdateTeamData.parseFrom(body)
            val command = UpdateTeamCommand.newBuilder()
                .setTeamId(teamId)
                .setOrganizationId(organizationId)
                .setTeam(data)
                .build()
            context.addProtobufItem(UpdateTeamCommand.getDescriptor().getAppHostType(), command)
        }

        delete("/organization/{organizationId}/teams/{teamId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val teamId = pathParameters["teamId"]
            val command = DeleteTeamCommand.newBuilder()
                .setTeamId(teamId)
                .setOrganizationId(organizationId)
                .build()
            context.addProtobufItem(DeleteTeamCommand.getDescriptor().getAppHostType(), command)
        }
    }
}
