package ru.yandex.crm.apphost.kotlin.handlers.teammanager

import NAppHostHttp.Http
import com.google.protobuf.Message
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.extensions.getSingleRequestItemOrNull
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamsResponse
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {
    override val path: String = "/response/team"

    override fun handle(ctx: RequestContext) {
        val teamsResponse = ctx.getSingleRequestItemOrNull(TeamsResponse.getDescriptor().getAppHostType())
            ?.getProtobufData(TeamsResponse.getDefaultInstance())
        if (teamsResponse !== null) {
            val response = buildHttpResponse(teamsResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }
    }

    private fun buildHttpResponse(response: Message): Http.THttpResponse {
        return Http.THttpResponse.newBuilder()
            .setContent(response.toByteString())
            .build()
    }
}
