package ru.yandex.crm.apphost.kotlin.handlers.teammanager

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.repository.OrganizationTeamRepository
import ru.yandex.crm.apphost.kotlin.dal.teammanager.schema.TeamManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.api.TeamService
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.repository.impl.OrganizationTeamRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.OrganizationTeamService
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.impl.OrganizationTeamServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.mappers.OrganizationTeamMapper
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.mappers.impl.OrganizationTeamMapperImpl
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withTeamManagerModule() = withModule(module {
    single { TeamManagerSchema() } bind HibernateSchema::class

    factory { params -> OrganizationTeamRepositoryImpl(params.get()) } bind OrganizationTeamRepository::class

    single { OrganizationTeamMapperImpl() } bind OrganizationTeamMapper::class
    single { OrganizationTeamServiceImpl(get()) } bind OrganizationTeamService::class

    single { TeamService(get()) } bind AppHostTypedServant::class

    single { HttpParserHandler(get()) } bind AppHostPathHandler::class
    single { HttpPresenterHandler() } bind AppHostPathHandler::class
})
