package ru.yandex.crm.apphost.kotlin.handlers.teammanager.api

import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.OrganizationTeamService
import ru.yandex.crm.apphost.proto.teammanager.TeamServiceBase
import ru.yandex.crm.apphost.proto.teammanager.Teammanager
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.Team
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamsResponse
import ru.yandex.web.apphost.api.request.RequestMeta
import java.util.*

class TeamService(
    private val service: OrganizationTeamService
) : TeamServiceBase() {

    override fun create(meta: RequestMeta, request: Teammanager.CreateTeamRequest): Teammanager.CreateTeamResponse {
        val data = request.createTeam.team
        val createdTeam = service.createOrganizationTeam(data)

        return Teammanager.CreateTeamResponse.newBuilder()
            .setTeamResponse(buildTeamsResponse(createdTeam))
            .build()
    }

    override fun update(meta: RequestMeta, request: Teammanager.UpdateTeamRequest): Teammanager.UpdateTeamResponse {
        val data = request.updateTeam
        val organizationId = data.organizationId
        val teamId = UUID.fromString(data.teamId)
        val updateTeamData = data.team
        val updatedTeam = service.updateOrganizationTeam(updateTeamData, organizationId, teamId)

        return Teammanager.UpdateTeamResponse.newBuilder()
            .setTeamResponse(buildTeamsResponse(updatedTeam))
            .build()
    }

    override fun delete(meta: RequestMeta, request: Teammanager.DeleteTeamRequest): Teammanager.DeleteTeamResponse {
        val data = request.deleteTeam
        val organizationId = data.organizationId
        val teamId = UUID.fromString(data.teamId)
        service.deleteOrganizationTeam(organizationId, teamId)

        return Teammanager.DeleteTeamResponse.newBuilder()
            .build()
    }

    override fun getById(meta: RequestMeta, request: Teammanager.GetTeamByIdRequest): Teammanager.GetTeamsResponse {
        val data = request.getTeam
        val organizationId = data.organizationId
        val teamId = UUID.fromString(data.teamId)
        val team = service.getOrganizationTeamById(organizationId, teamId)

        return Teammanager.GetTeamsResponse.newBuilder()
            .setTeamResponse(buildTeamsResponse(team))
            .build()
    }

    override fun getList(meta: RequestMeta, request: Teammanager.GetTeamListRequest): Teammanager.GetTeamsResponse {
        val data = request.getTeams
        val organizationId = data.organizationId
        val allTeams = service.getAllOrganizationTeams(organizationId)

        return Teammanager.GetTeamsResponse.newBuilder()
            .setTeamResponse(buildTeamsResponse(allTeams))
            .build()
    }

    private fun buildTeamsResponse(team: Team): TeamsResponse {
        return buildTeamsResponse(mutableListOf(team))
    }

    private fun buildTeamsResponse(teams: Collection<Team>): TeamsResponse {
        return TeamsResponse.newBuilder()
                    .addAllTeams(teams)
                    .build()
    }
}
