package ru.yandex.crm.apphost.kotlin.handlers.teammanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeam
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.repository.OrganizationTeamRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.UUID

class OrganizationTeamRepositoryImpl(
    session: Session
) : HibernateRepository<OrganizationTeam, UUID>(session, OrganizationTeam::class.java),OrganizationTeamRepository {

    override fun getAllOrganizationTeams(organizationId: Long): List<OrganizationTeam> {
        val params = mutableListOf<Pair<String, *>>("organizationId" to organizationId)

        val query = buildString {
            append("from OrganizationTeam ")
            append("where organization.id = :organizationId and is_deleted = false")
        }

        return findAll(query, params = params.toTypedArray())
    }

    override fun getOrganizationTeamById(organizationId: Long, teamId: UUID): OrganizationTeam? {
        val params = mutableListOf<Pair<String, *>>(
            "organizationId" to organizationId,
            "teamId" to teamId)

        val query = buildString {
            append("from OrganizationTeam ")
            append("where id = :teamId and organization.id = :organizationId and isDeleted = false")
        }

        return findOne(query, params = params.toTypedArray())
    }
}
