package ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeam
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamName
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamNameId
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.mappers.OrganizationTeamMapper
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.Team
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamData
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamName
import java.util.UUID

class OrganizationTeamMapperImpl : OrganizationTeamMapper {

    override fun toProtobufModel(organizationTeam: OrganizationTeam): Team {
        val protoNames = organizationTeam.names.map(this::toProtobufModel)
        val protoData = TeamData.newBuilder()
            .setOrganizationId(organizationTeam.organizationId)
            .setSecurityProfileId(organizationTeam.securityProfileId.toString())
            .addAllNames(protoNames)

        return Team.newBuilder()
            .setId(organizationTeam.id.toString())
            .setData(protoData)
            .build()
    }

    override fun toProtobufModel(organizationTeamName: OrganizationTeamName): TeamName {
        return TeamName.newBuilder()
            .setLanguageCode(organizationTeamName.id!!.languageCode)
            .setName(organizationTeamName.name)
            .build()
    }

    override fun fromProtobufModel(team: Team): OrganizationTeam {
        return fromProtobufModel(team.data).apply {
            id = UUID.fromString(team.id)
        }
    }

    override fun fromProtobufModel(teamData: TeamData): OrganizationTeam {
        return OrganizationTeam().apply {
            organizationId = teamData.organizationId
            securityProfileId = UUID.fromString(teamData.securityProfileId)
            names = teamData.namesList.map { fromProtobufModel(it, this) }.toMutableSet()
        }
    }

    override fun fromProtobufModel(
        teamDataName: TeamName,
        organizationTeam: OrganizationTeam
    )
    : OrganizationTeamName {
        return OrganizationTeamName(
            id = OrganizationTeamNameId(
                organizationTeam = organizationTeam,
                languageCode = teamDataName.languageCode),
            name = teamDataName.name
        )
    }
}
