package ru.yandex.crm.apphost.kotlin.handlers.teammanager.ut.repository

import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeam
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamName
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamNameId
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.repository.OrganizationTeamRepository
import java.util.UUID

class MockOrganizationTeamRepository: OrganizationTeamRepository {

    private val organizationTeams = mutableListOf(
        OrganizationTeam(
            id = UUID.fromString("f1f8ff22-8f68-4111-8aea-c40f515c0948"),
            organizationId = 1,
            securityProfileId = UUID.fromString("9866d4bd-10dc-4cbb-b0ad-83559c8bfe62"),
            names = mutableSetOf(
                OrganizationTeamName(
                    id = OrganizationTeamNameId(
                        organizationTeam = OrganizationTeam(id = UUID.fromString("f1f8ff22-8f68-4111-8aea-c40f515c0948")),
                        languageCode = "en"
                    ),
                    name = "Test"
                )),
            isDeleted = false
        ),
        OrganizationTeam(
            id = UUID.fromString("11f8ff22-8f68-4111-8aea-c40f515c0948"),
            organizationId = 1,
            securityProfileId = UUID.fromString("8866d4bd-10dc-4cbb-b0ad-83559c8bfe62"),
            names = mutableSetOf(
                OrganizationTeamName(
                    id = OrganizationTeamNameId(
                        organizationTeam = OrganizationTeam(id = UUID.fromString("11f8ff22-8f68-4111-8aea-c40f515c0948")),
                        languageCode = "en"
                    ),
                    name = "Test"
                )),
            isDeleted = false
        ),
        OrganizationTeam(
            id = UUID.fromString("21f8ff22-8f68-4111-8aea-c40f515c0948"),
            organizationId = 1,
            securityProfileId = UUID.fromString("7866d4bd-10dc-4cbb-b0ad-83559c8bfe62"),
            names = mutableSetOf(
                OrganizationTeamName(
                    id = OrganizationTeamNameId(
                        organizationTeam = OrganizationTeam(id = UUID.fromString("21f8ff22-8f68-4111-8aea-c40f515c0948")),
                        languageCode = "en"
                    ),
                    name = "Test"
                )),
            isDeleted = false
        ),
        OrganizationTeam(
            id = UUID.fromString("31f8ff22-8f68-4111-8aea-c40f515c0948"),
            organizationId = 1,
            securityProfileId = UUID.fromString("6866d4bd-10dc-4cbb-b0ad-83559c8bfe62"),
            names = mutableSetOf(
                OrganizationTeamName(
                    id = OrganizationTeamNameId(
                        organizationTeam = OrganizationTeam(id = UUID.fromString("31f8ff22-8f68-4111-8aea-c40f515c0948")),
                        languageCode = "en"
                    ),
                    name = "Test"
                )),
            isDeleted = true
        )
    )

    override fun getAllOrganizationTeams(organizationId: Long): List<OrganizationTeam> {
        return organizationTeams.filter { it.organizationId == organizationId && !it.isDeleted }
    }

    override fun getOrganizationTeamById(organizationId: Long, teamId: UUID): OrganizationTeam? {
        return organizationTeams.firstOrNull {
            it.organizationId == organizationId
                && it.id == teamId
                && !it.isDeleted }
    }

    override fun findOne(id: UUID): OrganizationTeam? {
        return organizationTeams.firstOrNull { it.id == id }
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): OrganizationTeam? {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<OrganizationTeam> {
        return organizationTeams
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<OrganizationTeam> {
        TODO("Not yet implemented")
    }

    override fun save(entity: OrganizationTeam): OrganizationTeam {
        if (entity.id == null) {
            entity.id = UUID.randomUUID()
            organizationTeams.add(entity)
            return entity
        }

        val savedEntity = organizationTeams.firstOrNull { it.id == entity.id }
        if (savedEntity == null) {
            organizationTeams.add(entity)
            return entity
        }

        savedEntity.names = entity.names
        savedEntity.isDeleted = entity.isDeleted
        savedEntity.organizationId = entity.organizationId
        savedEntity.securityProfileId = entity.securityProfileId

        return savedEntity
    }

    override fun delete(id: UUID) {
        organizationTeams.removeIf { it.id == id }
    }

    override fun delete(entity: OrganizationTeam) {
        organizationTeams.remove(entity)
    }
}
