package ru.yandex.crm.apphost.kotlin.handlers.teammanager.ut.service.mappers

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeam
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamName
import ru.yandex.crm.apphost.kotlin.dal.teammanager.OrganizationTeamNameId
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.service.mappers.impl.OrganizationTeamMapperImpl
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.Team
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamData
import ru.yandex.crm.proto.gallifrey.teammanager.Teammanager.TeamName
import java.util.UUID
import kotlin.properties.Delegates
import kotlin.test.assertEquals
import kotlin.test.assertTrue

class OrganizationTeamMapperTests: KoinTest {

    private var mapper: OrganizationTeamMapperImpl by Delegates.notNull()

    @BeforeEach
    fun beforeEach() {
        mapper = OrganizationTeamMapperImpl()
    }

    @Test
    fun `from protobuf model test`() {
        val teamIdString = "f1f8ff22-8f68-4111-8aea-c40f515c0948"
        val securityProfileIdString = "9866d4bd-10dc-4cbb-b0ad-83559c8bfe62"
        val teamName = "test"

        val teamProtobuf = Team.newBuilder()
            .setId(teamIdString)
            .setData(TeamData.newBuilder()
                .setOrganizationId(1)
                .setSecurityProfileId(securityProfileIdString)
                .addAllNames(mutableListOf(
                    TeamName.newBuilder()
                        .setLanguageCode("en")
                        .setName(teamName)
                        .build()
                ))
                .build())
            .build()

        val entity = mapper.fromProtobufModel(teamProtobuf)
        assertEquals(teamIdString, entity.id.toString())
        assertEquals(1, entity.organizationId)
        assertEquals(securityProfileIdString, entity.securityProfileId.toString())
        assertTrue(entity.names.any())
        assertTrue(entity.names.any { it.id == OrganizationTeamNameId(entity, "en") && it.name == teamName })
    }

    @Test
    fun `to protobuf model test`() {
        val teamIdString = "f1f8ff22-8f68-4111-8aea-c40f515c0948"
        val securityProfileIdString = "9866d4bd-10dc-4cbb-b0ad-83559c8bfe62"
        val teamName = "test"

        val entity = OrganizationTeam().apply {
            id = UUID.fromString(teamIdString)
            organizationId = 1
            securityProfileId = UUID.fromString(securityProfileIdString)
            names = mutableSetOf(
                OrganizationTeamName(
                    OrganizationTeamNameId(this, "en"),
                    teamName
                )
            )
        }

        val protobuf = mapper.toProtobufModel(entity)
        assertEquals(teamIdString, protobuf.id)
        assertEquals(1, protobuf.data.organizationId)
        assertEquals(securityProfileIdString, protobuf.data.securityProfileId)
        assertTrue(protobuf.data.namesList.any { it.name == teamName && it.languageCode == "en" })
    }
}
