package ru.yandex.crm.apphost.kotlin.handlers.usermanager

import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.http.parser.HttpParserHandlerBase
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.RemoveUserFromOrganizationCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.AddUserToOrganizationCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetOrganizationUsersCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.ArchiveUserCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.CreateUserCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetOrganizationUsersByPatternCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetUserByIdCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetUsersListCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.UpdateUserCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UpdateUserData
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserData
import ru.yandex.passport.tvmauth.TvmClient

class HttpParserHandler(tvmClient: TvmClient) : HttpParserHandlerBase(tvmClient) {

    override val path = "/init/user"

    init {
        get("users/list") {
            val command = GetUsersListCommand.newBuilder().build()
            context.addProtobufItem(GetUsersListCommand.getDescriptor().getAppHostType(), command)
        }

        get("user/{id}") {
            val userId = pathParameters["id"]!!.toLong()
            val command = GetUserByIdCommand.newBuilder()
                .setUserId(userId)
                .build()
            context.addProtobufItem(GetUserByIdCommand.getDescriptor().getAppHostType(), command)
        }

        put("user/create") {
            val body = request.content
            val userModel = UserData.parseFrom(body)
            val command = CreateUserCommand.newBuilder()
                .setTargetUser(userModel)
                .build()
            context.addProtobufItem(CreateUserCommand.getDescriptor().getAppHostType(), command)
        }

        patch("user/{id}/update") {
            val body = request.content
            val userId = pathParameters["id"]!!.toLong()
            val userModel = UpdateUserData.parseFrom(body)
            val command = UpdateUserCommand.newBuilder()
                .setUserId(userId)
                .setTargetUser(userModel)
                .build()
            context.addProtobufItem(UpdateUserCommand.getDescriptor().getAppHostType(), command)
        }

        post("user/{id}/archive") {
            val userId = pathParameters["id"]!!.toLong()
            val command = ArchiveUserCommand.newBuilder()
                .setUserId(userId)
                .build()
            context.addProtobufItem(ArchiveUserCommand.getDescriptor().getAppHostType(), command)
        }

        get("user/organization/list/{organizationId}?pattern={pattern}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val pattern = requestParameters["pattern"]

            if (pattern== null){
                val command = GetOrganizationUsersCommand.newBuilder()
                    .setOrganizationId(organizationId)
                    .build()
                context.addProtobufItem(GetOrganizationUsersCommand.getDescriptor().getAppHostType(), command)
            }
            else {
                val command = GetOrganizationUsersByPatternCommand.newBuilder()
                    .setOrganizationId(organizationId)
                    .setPattern(pattern)
                    .build()
                context.addProtobufItem(GetOrganizationUsersByPatternCommand.getDescriptor().getAppHostType(), command)
            }
        }

        put("user/organization/add/{organizationId}/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val userId = pathParameters["userId"]!!.toLong()
            val command = AddUserToOrganizationCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(AddUserToOrganizationCommand.getDescriptor().getAppHostType(), command)
        }

        delete("user/organization/remove/{organizationId}/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val userId = pathParameters["userId"]!!.toLong()
            val command = RemoveUserFromOrganizationCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(RemoveUserFromOrganizationCommand.getDescriptor().getAppHostType(), command)
        }
    }
}
