package ru.yandex.crm.apphost.kotlin.handlers.usermanager

import NAppHostHttp.Http.THttpResponse
import com.google.protobuf.Message
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.extensions.getSingleRequestItemOrNull
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.OrganizationUsersResponse
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserResponse
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {

    override val path = "/response/entity"

    override fun handle(ctx: RequestContext) {
        val singleUserResponse = ctx.getSingleRequestItemOrNull(UserResponse.getDescriptor().getAppHostType())
            ?.getProtobufData(UserResponse.getDefaultInstance())
        if (singleUserResponse != null) {
            val response = buildHttpResponse(singleUserResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val usersResponse = ctx.getSingleRequestItemOrNull(UsersResponse.getDescriptor().getAppHostType())
            ?.getProtobufData(UsersResponse.getDefaultInstance())
        if (usersResponse != null) {
            val response = buildHttpResponse(usersResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val organizationUserResponse =
            ctx.getSingleRequestItemOrNull(OrganizationUsersResponse.getDescriptor().getAppHostType())
                ?.getProtobufData(OrganizationUsersResponse.getDefaultInstance())
        if (organizationUserResponse != null) {
            val response = buildHttpResponse(organizationUserResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }
    }

    private fun buildHttpResponse(response: Message): THttpResponse {
        return THttpResponse.newBuilder()
            .setContent(response.toByteString())
            .build()
    }
}
