package ru.yandex.crm.apphost.kotlin.handlers.usermanager

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.AddUserToOrganizationHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.ArchiveUserHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.CreateUserHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.GetOrganizationUsersByPatternHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.GetOrganizationUsersHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.GetUserHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.GetUsersListHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.RemoveUserFromOrganizationHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.api.UpdateUserHandler
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.OrganizationUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.UserRepository
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.impl.OrganizationUserRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.OrganizationLinkerService
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.impl.OrganizationLinkerServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.impl.UserServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.UserEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.impl.UserEntityMapperImpl
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder

fun HostBuilder.withUserManager() = withModule(module {

    single { UserManagerSchema() } bind HibernateSchema::class
    single { OrganizationManagerSchema() } bind HibernateSchema::class
    factory { params -> UserRepository(params.get()) } bind UserRepository::class
    factory { params -> OrganizationUserRepositoryImpl(params.get()) } bind OrganizationUserRepository::class

    single { UserEntityMapperImpl() } bind UserEntityMapper::class

    single { UserServiceImpl(get()) } bind UserService::class
    single { OrganizationLinkerServiceImpl() } bind OrganizationLinkerService::class

    single { ArchiveUserHandler(get()) } bind AppHostPathHandler::class
    single { CreateUserHandler(get()) } bind AppHostPathHandler::class
    single { GetUserHandler(get()) } bind AppHostPathHandler::class
    single { GetUsersListHandler(get()) } bind AppHostPathHandler::class
    single { UpdateUserHandler(get()) } bind AppHostPathHandler::class
    single { GetOrganizationUsersByPatternHandler(get()) } bind AppHostPathHandler::class
    single { GetOrganizationUsersHandler(get()) } bind AppHostPathHandler::class
    single { AddUserToOrganizationHandler(get()) } bind AppHostPathHandler::class
    single { RemoveUserFromOrganizationHandler(get()) } bind AppHostPathHandler::class

    single { HttpParserHandler(get()) } bind AppHostPathHandler::class
    single { HttpPresenterHandler() } bind AppHostPathHandler::class
})

