package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.OrganizationLinkerService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.AddUserToOrganizationCommand
import ru.yandex.web.apphost.api.request.RequestContext

class AddUserToOrganizationHandler(
    private val service: OrganizationLinkerService
): AppHostPathHandler {

    override val path = "/user/add-to-organization"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(AddUserToOrganizationCommand.getDescriptor().getAppHostType())
            .getProtobufData(AddUserToOrganizationCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val userId = command.userId

        service.addUserToOrganization(userId, organizationId)
    }
}
