package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.util.AuditUtil
import ru.yandex.crm.apphost.proto.auditor.Auditor.DeleteEntityLog
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.ArchiveUserCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserResponse
import ru.yandex.web.apphost.api.request.RequestContext

class ArchiveUserHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/archive"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(ArchiveUserCommand.getDescriptor().getAppHostType())
            .getProtobufData(ArchiveUserCommand.getDefaultInstance())

        val userId = command.userId
        val archivedUser = service.archiveUser(userId)

        val deleteLog = AuditUtil.buildDeleteUserLog(archivedUser)
        ctx.addProtobufItem(DeleteEntityLog.getDescriptor().getAppHostType(), deleteLog)

        val response = UserResponse.newBuilder()
            .setUser(archivedUser)
            .build()
        ctx.addProtobufItem(UserResponse.getDescriptor().getAppHostType(), response)
    }
}
