package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.util.AuditUtil
import ru.yandex.crm.apphost.proto.auditor.Auditor.CreateEntityLog
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.CreateUserCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserResponse
import ru.yandex.web.apphost.api.request.RequestContext

class CreateUserHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/create"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(CreateUserCommand.getDescriptor().getAppHostType())
            .getProtobufData(CreateUserCommand.getDefaultInstance())

        val newUser = command.targetUser
        val createdUser = service.createUser(newUser)

        val createLog = AuditUtil.buildCreateUserLog(createdUser)
        ctx.addProtobufItem(CreateEntityLog.getDescriptor().getAppHostType(), createLog)

        val response = UserResponse.newBuilder()
            .setUser(createdUser)
            .build()
        ctx.addProtobufItem(UserResponse.getDescriptor().getAppHostType(), response)
    }
}
