package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetOrganizationUsersByPatternCommand
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetOrganizationUsersCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.OrganizationUsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationUsersByPatternHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/get-organization-users-by-pattern"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetOrganizationUsersByPatternCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetOrganizationUsersByPatternCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val pattern = command.pattern
        val users = service.getOrganizationUsers(organizationId, pattern)

        val response = OrganizationUsersResponse.newBuilder()
            .addAllUsersId(users.map { it.userId })
            .build()
        ctx.addProtobufItem(OrganizationUsersResponse.getDescriptor().getAppHostType(), response)
    }
}
