package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetOrganizationUsersCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.OrganizationUsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationUsersHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/get-organization-users"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetOrganizationUsersCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetOrganizationUsersCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val users = service.getOrganizationUsers(organizationId)

        val response = OrganizationUsersResponse.newBuilder()
            .addAllUsersId(users.map { it.userId })
            .build()
        ctx.addProtobufItem(OrganizationUsersResponse.getDescriptor().getAppHostType(), response)
    }
}
